//
//  CRFramerBorder.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 3/25/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRFramer.h"

extern NSString* const CRFramerBorderBorderSizeKey;
extern NSString* const CRFramerBorderBorderOverlapKey;
extern NSString* const CRFramerBorderApplyShaderToBorderKey;

//////////////////////////////////////////////////////////////////////
// Border frame generator. Uses material texture as a border image
// that is scaled to fit given size and tiled to cover whole
// perimeter
//////////////////////////////////////////////////////////////////////
@interface CRFramerBorder : CRFramer
{
	BOOL materialIsShader; // flag signals whether specified material is from the Shader family
}

@property (nonatomic, readonly)	BOOL materialIsShader;
@property (nonatomic, assign)	BOOL applyShaderToBorder;

@property (nonatomic, assign)	CGFloat borderSize;
@property (nonatomic, assign)	CGFloat borderOverlap;

@end